<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Runner\BytecodeHelper;

/**
 * Class RegexMatch
 *
 * @package Ghoti\Tools\Lispian\VM\Runner\BytecodeHelper
 */
class RegexMatch
{
    /** @var RegexMatch[] */
    protected static $instances = [];

    /** @var string */
    protected $key;
    /** @var string */
    protected $regex;
    /** @var string */
    protected $subject;
    /** @var int */
    protected $offset;

    /**
     * @param string $regex
     * @param string $subject
     * @return RegexMatch
     */
    public static function getHelper(string $regex, string $subject): RegexMatch
    {
        $key = static::getKey($regex, $subject);

        if (!\array_key_exists($key, static::$instances)) {
            static::$instances[$key] = new static($regex, $subject, $key);
        }

        return static::$instances[$key];
    }

    /**
     * @param string $regex
     * @param string $subject
     * @return string
     */
    public static function getKey(string $regex, string $subject)
    {
        return \md5($regex .'@@'. $subject);
    }

    /**
     * @param array|null $matches
     * @return bool
     */
    public function match(array &$matches = null): bool
    {
        if (!\preg_match($this->regex, $this->subject, $localMatches, \PREG_OFFSET_CAPTURE, $this->offset)) {
            $this->delete();
            return false;
        }

        list($fullMatch, $offset) = $localMatches[0];
        $this->offset = $offset + \strlen($fullMatch);

        $matches = [];
        foreach ($localMatches as $key => list($value)) {
            if (!\is_int($key)) {
                $matches[$key] = $value;
            }
        }

        return true;
    }

    /**
     * @param RegexMatch $instance
     */
    protected static function deleteInstance(RegexMatch $instance)
    {
        unset(static::$instances[$instance->key]);
    }

    /**
     * RegexMatch constructor.
     *
     * @param string $regex
     * @param string $subject
     * @param string $key
     */
    protected function __construct(string $regex, string $subject, string $key)
    {
        $this->offset = 0;
        $this->regex = $regex;
        $this->subject = $subject;
        $this->key = $key;
    }

    /**
     * @return RegexMatch
     */
    protected function delete(): self
    {
        static::deleteInstance($this);
        return $this;
    }
}
