<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Compiler;

use Ghoti\Tools\Lispian\Assembly\Node\Pr0gram;

/**
 * Class StaticData
 * @package Ghoti\Tools\Lispian\VM\Compiler
 */
class StaticData
{
    /** @var array */
    protected $data;
    /** @var array */
    protected $keys;

    /**
     * StaticData constructor.
     */
    public function __construct()
    {
        $this->data = [];
        $this->keys = [];
    }

    /**
     * @param $data
     * @return int
     */
    public function getReference($data): int
    {
        $dataKey = $this->getDataKey(\serialize($data));

        if (!\array_key_exists($dataKey, $this->keys)) {
            $this->keys[$dataKey] = \count($this->data);

            if (!\is_array($data)) {
                $this->data[] = $data;
            } else {
                $this->data[] = \count($data);

                foreach ($data as $datum) {
                    $this->data[] = $datum;
                }
            }
        }

        return $this->keys[$dataKey] + Pr0gram::PROLOG;
    }

    /**
     * @return array
     */
    public function getStaticData(): array
    {
        return \array_values($this->data);
    }

    /**
     * @param string $serialized
     * @return string
     */
    protected function getDataKey(string $serialized): string
    {
        return \sha1($serialized);
    }
}
