<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Exception\Parser;

use Ghoti\Tools\Lispian\Exception\Exception;
use Ghoti\Tools\Lispian\Parser;
use Throwable;

/**
 * Class UnexpectedTokenException
 * @package Ghoti\Tools\Lispian\Exception\Parser
 */
class UnexpectedTokenException extends Exception
{
    /**
     * UnexpectedTokenException constructor.
     *
     * @param Parser $parser
     * @param Throwable|null $previousException
     */
    public function __construct(Parser $parser, Throwable $previousException = null)
    {
        $code = 1541176941;
        $token = $parser->YYToken();
        $value = $parser->YYValue();

        $message = \sprintf('Unexpected token "%s"%s at input line %d, column %d',
            $token, '' !== $value ? " (>$value<)" : '',
            $parser->getSourceLine(), $parser->getSourceColumn() - \strlen($value));

        parent::__construct($message, $code, $previousException);
    }
}
