<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Exception\Lexer;

use Ghoti\Tools\Lispian\Lexical\Lexer;

/**
 * Class UnterminatedStringException
 * @package Ghoti\Tools\Lispian\Exception\Lexer
 */
class UnterminatedStringException extends AbstractLexerException
{
    public function __construct(Lexer $lexer, string $source, \Throwable $previousException = null)
    {
        $code = 1540993642;
        $message = \sprintf('Unterminated string at line %d, column %d: "%s"',
            $lexer->getLine(), $lexer->getColumn(), \substr($source, 0, 8));

        parent::__construct($message, $code, $previousException);
    }
}
