<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Literal;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Statement\Expressions;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class ListOfThings
 * @package Ghoti\Tools\Lispian\Assembly\Node\Literal
 */
class ListOfThings extends AbstractNode
{
    /**
     * ListOfThings constructor.
     *
     * @param NodeInterface $expressions
     */
    public function __construct(NodeInterface $expressions)
    {
        parent::__construct('lot', $expressions);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        if ($this->isConstantList()) {
            $list = [];

            /** @var AbstractLiteral $node */
            foreach ($this->left as $node) {
                $list[] = $node->getConstantValue();
            }

            return [
                OpCode::get(OpCode::LOADA),
                $helper->getStaticData()->getReference($list)
            ];
        }

        $code = [];
        $length = 0;

        /** @var AbstractNode $node */
        foreach ($this->left as $node) {
            $helper->spliceNode($code, $node);
            $code[] = OpCode::get(OpCode::PUSH);
            ++$length;
        }

        $code[] = OpCode::get(OpCode::POPA);
        $code[] = $length;

        return $code;
    }

    /**
     * @return bool
     */
    protected function isConstantList(): bool
    {
        /** @var Expressions $expressions */
        $expressions = $this->left;

        foreach ($expressions as $expression) {
            if (!$expression instanceof AbstractLiteral) {
                return false;
            }
        }

        return true;
    }
}
