<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\FlowControl;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Helper\JumpReference;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Statement\Expressions;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class WhileLoop
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\FlowControl
 */
class WhileLoop extends AbstractNode
{
    /**
     * WhileLoop constructor.
     *
     * @param NodeInterface $condition
     * @param NodeInterface|null $loop
     */
    public function __construct(NodeInterface $condition, NodeInterface $loop = null)
    {
        parent::__construct('T_WHILE', $condition, $loop);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var Expressions $expressions */
        $expressions = $this->right;

        $loop = new JumpReference();
        $out = new JumpReference();

        $code = [OpCode::get(OpCode::SCOPE_INIT)];
        $code[] = $loop->here();
        $helper->spliceNode($code, $this->left);
        $helper->spliceCode($code, [
            OpCode::get(OpCode::JZ),
            $out
        ])->spliceExpressions($code, $expressions);

        $helper->spliceCode($code, [
            OpCode::get(OpCode::JMP),
            $loop,
            $out->here(),
            OpCode::get(OpCode::SCOPE_RET)
        ]);

        return $code;
    }
}
