<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Regex
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Arithmetic
 */
class Regex extends AbstractNode
{
    /**
     * Regex constructor.
     *
     * @param NodeInterface $left
     * @param array $regex
     */
    public function __construct(NodeInterface $left, array $regex)
    {
        parent::__construct('~', $left, $regex);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $regex = (array) $this->right;
        $pattern = $regex['rx'] . ($regex['fl'] ?? '');
        $key = $helper->getStaticData()->getReference($pattern);

        $code = [];
        $helper->spliceNode($code, $this->left)
            ->spliceCode($code, [
                OpCode::get(OpCode::PUSH),
                OpCode::get(OpCode::LOAD),
                $key,
                OpCode::get(OpCode::MATCH)
            ]);

        return $code;
    }
}
