<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Plurary
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode
 */
class Plurary extends AbstractNode
{
    /** @var array */
    const OPCODES = [
        'eq' => OpCode::CMPEQ,
        'is' => OpCode::CMPEQ,
        'ne' => OpCode::CMPNE,
        'gt' => OpCode::CMPGT,
        'gte' => OpCode::CMPGTE,
        'lt' => OpCode::CMPLT,
        'lte' => OpCode::CMPLTE
    ];

    /**
     * Plurary constructor.
     *
     * @param string $operator
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(string $operator, NodeInterface $left, NodeInterface $right)
    {
        parent::__construct($operator, $left, $right);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $left = $this->left->compile($helper);
        $right = $this->right->compile($helper);

        return \array_merge(
            $left,
            [OpCode::get(OpCode::PUSH)],
            $right,
            [OpCode::get(static::OPCODES[$this->operator])]
        );
    }
}
