<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Exponentiation
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Arithmetic
 */
class Exponentiation extends AbstractNode
{
    /**
     * Exponentiation constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(NodeInterface $left, NodeInterface $right)
    {
        parent::__construct('**', $left, $right);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        return \array_merge(
            $this->left->compile($helper),
            [OpCode::get(OpCode::PUSH)],
            $this->right->compile($helper),
            [OpCode::get(OpCode::POW)]
        );
    }
}
