# Lispian documentation #

## Flow control ##

### if ###

Since all expressions have a value, the `if` construct is not *really* needed in *Lispian* but
exists nonetheless, since it's a core instruction in all high-level and interpreted languages.

The `if` flow control statement requires a condition and a "follows" block and MAY be followed
by an "if-not" (else) block.

**Examples**

Print something if something is true

```lisp
(if (some_function_returning_a_true_value)
    (print "The function returned a true value.")
)
```

One statement if a condition is true, one statement if the condition is false

```lisp
# Extra whitespace added for clarity:
(if 
    (and $a $b)                       # condition
    (print "Both are true")           # "follows" statement
    (print "One of them isn't true")  # "else" statement
)
```

Multiple expressions per control branch:

```lisp
(if $somevariable
    (do
        (print "The variable evaluated to true")
        (let $somevariable false)
    )
    
    (do
        (print "The variable was false to begin with")
        (let $somevariable (not $somevariable)
    )
)
```

#### Return value ####

The `if` flow-control statement, as any of the other flow-control statements has no intrinsic return
value; the last executed statement in either its "follows" or "else" blocks provide the return values
instead. This is true, if the evaluation of the condition lead to the execution of a code block. For an
`if` statement without "else" blocks, the compound statement's return value is `0` (false-ish) should its
condition evaluate to a false-ish value.

The above gibberish is illustrated in this example:

```php
$result = lispianRun('(if (always_false) (print "Never here."))');
// $result --> (int) 0
``` 

Since there is no "else" block, that might provide another return value for the `if` compound, the failed
condition's return value is used instead; and that is always "false" (`0`).

### while ###

Execute statements while a condition evaluates to `true`. There's nothing much else to say about it. 
Lispian's `while` behaves like its counterparts in any other language.

**Example**

```lisp
# Print ten lines of "x > 0", then terminate loop

(let $a 10)
(while (gt $a 0)
    (printf "%d > 0\n" $a)
    (dec $a))
```
