<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Exception\Lexer;

use Ghoti\Tools\Lispian\Lexical\Lexer;

/**
 * Class InvalidCharacterException
 * @package Ghoti\Tools\Lispian\Exception\Lexer
 */
class InvalidCharacterException extends AbstractLexerException
{
    public function __construct(Lexer $lexer, string $invalidCharacter, \Throwable $previousException = null)
    {
        $code = 1540993642;
        $message = \sprintf('Unexpected input at line %d, column %d: "%s"',
            $lexer->getLine(), $lexer->getColumn(), \substr($invalidCharacter, 0, 8));

        parent::__construct($message, $code, $previousException);
    }
}
