<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Symbolic;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Constant
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Symbolic
 */
class Constant extends AbstractNode
{
    /**
     * Constant constructor.
     *
     * @param string $constant
     */
    public function __construct(string $constant)
    {
        parent::__construct('T_CONSTANT', $constant);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        return [OpCode::MOVA, $this->getConstantValue()];
    }

    /**
     * @return int|null
     */
    protected function getConstantValue()
    {
        if ('true' === $this->left) {
            return 1;
        }

        if ('false' === $this->left) {
            return 0;
        }

        return null;
    }
}
