<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Literal;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Number
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Literal
 */
class Number extends AbstractNode
{
    /**
     * Number constructor.
     * @param float $value
     */
    public function __construct(float $value)
    {
        parent::__construct('number', $value);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        return [OpCode::MOVA, $this->left];
    }

    /**
     * @return string
     */
    public function stringify(): string
    {
        return $this->left;
    }
}
