<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Statement\Expressions;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Division
 * @package Ghoti\Tools\Lispian\Assembly\Node\Arithmetic
 */
class Division extends AbstractNode
{
    /**
     * Division constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     * @param NodeInterface $more
     */
    public function __construct(NodeInterface $left, NodeInterface $right, NodeInterface $more)
    {
        parent::__construct('/', $left, $right, $more);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var Expressions $more */
        $more = $this->next;

        $code = \array_merge(
            $this->left->compile($helper),
            [OpCode::PUSH],
            $this->right->compile($helper),
            [OpCode::DIV]
        );

        /** @var AbstractNode $node */
        foreach ($more as $node) {
            $code[] = OpCode::PUSH;
            $helper->spliceNode($code, $node);
            $code[] = OpCode::DIV;
        }

        return $code;
    }
}
