<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Boolean
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Arithmetic
 */
class Boolean extends AbstractNode
{
    /**
     * Boolean constructor.
     *
     * @param string $operator
     * @param NodeInterface $left
     */
    public function __construct(string $operator, NodeInterface $left)
    {
        parent::__construct($operator, $left);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        static $numJumpInstructions = 2;

        /** @var AbstractNode $expressions */
        $expressions = $this->left;
        /** @var AbstractNode[] $conditions */
        $conditions = $expressions->left;
        $fragments = [];
        $code = [];
        $opcode = 'and' === $this->operator ? OpCode::JZ : OpCode::JNZ;
        $totalFragments = \count($conditions) - 1;
        $totalInstructions = 0;

        /** @var NodeInterface $condition */
        foreach ($conditions as $index => $condition) {
            $compiled = $condition->compile($helper);
            $numInstructions = \count($compiled);
            $fragments[] = [$numInstructions, $compiled];
            $totalInstructions += $numInstructions;
            if ($index < $totalFragments) {
                $totalInstructions += $numJumpInstructions;
            }
        }

        foreach ($fragments as $index => list($numInstructions, $fragment)) {
            foreach ($fragment as $instruction) {
                $code[] = $instruction;
            }

            if ($index < $totalFragments) {
                $totalInstructions -= $numInstructions;
                $code[] = $opcode;
                $code[] = $totalInstructions;
            }

            $totalInstructions -= $numJumpInstructions;
        }

//foreach ($code as $n => $l) {
//    $extra='';
//    if ($l==='jnz') {
//        $extra = ' ==>'.($n + $code[$n+1]);
//    }
//    printf("%2d %s%s\n", $n, $l, $extra);
//}
//die;
        return $code;
    }
}
