<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Helper;

/**
 * Class JumpReference
 *
 * @package Ghoti\Tools\Lispian\Assembly\Helper
 */
class JumpReference
{
    /** @var string */
    const LIFTOFF = 'liftoff';
    /** @var string */
    const LANDING = 'landing';

    /** @var array */
    static protected $references = [];

    /** @var string */
    protected $key;
    /** @var string */
    protected $type;

    /**
     * JumpReference constructor.
     * @param string $type
     */
    public function __construct(string $type = self::LIFTOFF)
    {
        $this->key = $this->generateKey();
        $this->type = $type;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    /**
     * @return bool
     */
    public function isTarget(): bool
    {
        return static::LANDING === $this->type;
    }

    /**
     * @return JumpReference
     */
    public function here(): JumpReference
    {
        $reference = new static(static::LANDING);
        $reference->key = $this->key;
        return $reference;
    }

    /**
     * @return string
     */
    protected function generateKey(): string
    {
        while (true) {
            $key = \uniqid(__CLASS__, true);
            if (!\array_key_exists($key, static::$references)) {
                static::$references[$key] = true;
                return $key;
            }
        }

        return null; // Thank you, PhpStorm.
    }
}
