<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Support\Builtins\Functions;

use Ghoti\Tools\Lispian\VM\Support\SymbolProvider;

/**
 * Class BuiltinFunctionsFactory
 * @package Ghoti\Tools\Lispian\VM\Support\Builtins\Functions
 */
class BuiltinFunctionsFactory
{
    /** @var BuiltinFunctionsFactory */
    static protected $instance;

    /**
     * @return BuiltinFunctionsFactory
     */
    public static function getInstance(): self
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    /**
     * @param SymbolProvider $provider
     */
    public function addToProvider(SymbolProvider $provider)
    {
        $builtins = [];

        $builtins['print'] = function(...$arguments) {
            foreach ($arguments as $argument) {
                print $argument;
            }
            return 1;
        };

        foreach (['date','printf','strftime','time','var_dump' => 'dump'] as $function => $alias) {
            if (\is_int($function)) {
                $function = $alias;
            }
            $builtins[$alias] = function (...$arguments) use($function) {
                return +$function(...$arguments);
            };
        }

        $provider->setSymbols($builtins);
    }
}
