<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM;

/**
 * Class OpCodeFast
 * @package Ghoti\Tools\Lispian\VM
 */
class OpCodeFast
{
    const PR0GRAM_INIT      = 0x4F53;
    const PR0GRAM_END       = 0x4B4B;
    const SCOPE_INIT        = 0x0010;
    const SCOPE_RET         = 0x0011;
    const LOAD              = 0x000d;
    const PUSH              = 0x0012;
    const POP               = 0x0014;
    const MOVA              = 0x0015;
    const POPVAR            = 0x0016;
    const POPSYM            = 0x0017;

    const JMP               = 0x0020;
    const JZ                = 0x0021;
    const JNZ               = 0x0022;
    const CMPEQ             = 0x0023;
    const CMPNE             = 0x0024;
    const CMPLT             = 0x0025;
    const CMPLTE            = 0x0026;
    const CMPGT             = 0x0027;
    const CMPGTE            = 0x0028;

    const NOT               = 0x0030;
    const CALL              = 0x0031;
    const INVOKE            = 0x0032;
    const RET               = 0x0033;

    const ADD               = 0x0040;

    const NOP               = 0x0090; // Gotta follow tradition.
    const LOOKUP            = 0x00F0; // F --> find
    const DOT               = 0x00F1;
}
