#
# Lispian grammar file
#

%{
use Ghoti\Tools\Lispian\Assembly\Node;
%}

%%

program         : statements { return new Node\Pr0gram($_[1]) }
                ;

statements      : _statements { return new Node\Statement\Statement($_[1] ?? [new Node\Instruction\Nop()]) }
                ;

_statements     : # empty
                | _statements root_statement { @$_[1][] = $_[2]; return $_[1]; }
                ;

root_statement  : function_declaration
                | statement
                ;

statement       : '(' statement_body ')' { return $_[2] }
                | function_call
                ;

statement_body  : unary
                | plurary
                | boolean
                | if_condition
                | assignment
                ;

unary           : unary_op expression { return new Node\Arithmetic\Unary($_[1], $_[2]) }
                ;

unary_op        : 'not' ;

plurary         : plurary_op expression expression { return new Node\Arithmetic\Plurary($_[1], $_[2], $_[3]) }
                ;

plurary_op      : 'is' | 'eq' | 'ne' | 'lt' | 'lte' | 'gt' | 'gte' ;

boolean         : boolean_op expression_list { return new Node\Arithmetic\Boolean($_[1], $_[2]) }
                ;

boolean_op      : 'and' | 'or' ;

if_condition    : T_IF expression expression_chain else_statement
                    { return new Node\Instruction\IfCondition($_[2], $_[3], $_[4]) }
                ;

else_statement  : # empty
                | expression_chain
                ;

assignment      : T_LET variable expression { return new Node\Instruction\Assignment($_[2], $_[3]) }
                ;

expression      : statement
                | literal
                | list
                | constant
                | dotaccess
                ;

expression_list : expressions { return new Node\Statement\Expressions($_[1]) }
                ;

expression_chain: expression_chain ',' expression { return new Node\Statement\ExpressionChain($_[1], $_[3]) }
                | expression
                ;

expressions     : # empty
                | expressions expression { @$_[1][] = $_[2]; return $_[1] }
                ;


literal         : T_STRING { return new Node\Literal\AsciiSequence($_[1]) }
                | T_NUMBER { return new Node\Literal\Number($_[1]) }
                ;

constant        : T_CONSTANT { return new Node\Symbolic\Constant($_[1]) }
                ;

variable        : T_VARIABLE { return new Node\Symbolic\Variable($_[1]) }
                ;

dotaccess       : variable dotaccess_chain {
                    if (null === $_[2]) {
                        return $_[1];
                    }
                    return new Node\Instruction\Dot($_[1], $_[2])
                }
                ;

dotaccess_chain : # empty
                | dotaccess_chain '.' identifier { @$_[1][] = $_[3]; return $_[1] }
                ;

identifier      : T_IDENTIFIER { return new Node\Symbolic\Identifier($_[1]) }
                ;

list            : '(' expression_list ')' { return new Node\Literal\ListOfThings($_[2]) }
                ;

function_call   : '(' identifier expression_list ')'
                        { return new Node\Functions\Call($_[2], $_[3]) }
                ;

function_declaration: '(' T_DEFUN identifier parameter_list statement ')'
                        { return new Node\Functions\Definition($_[3], $_[5], $_[4]) }
                ;

parameter_list  : '(' parameters ')' { return $_[2] }
                ;

parameters      : # empty
                | parameters T_VARIABLE { @$_[1][] = $_[2]; return $_[1]; }
                ;

%%
