<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Symbolic;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Variable
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Symbolic
 */
class Variable extends AbstractNode
{
    /**
     * Variable constructor.
     * @param string $variable
     */
    public function __construct(string $variable)
    {
        parent::__construct('T_VAR', $variable);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        return [OpCode::LOOKUP, $this->left];
    }

    /**
     * @return string
     */
    public function stringify(): string
    {
        return (string) $this->left;
    }
}
