<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Statement;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Statement
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode
 */
class Statement extends AbstractNode
{
    /**
     * Statement constructor.
     *
     * @param NodeInterface[] $nodes
     */
    public function __construct(array $nodes)
    {
        parent::__construct('STMT', $nodes);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        $code = [OpCode::SCOPE_INIT];

        /** @var NodeInterface $node */
        foreach ($this->left as $node) {
            /** @noinspection SlowArrayOperationsInLoopInspection */
            $code = \array_merge($code, $node->compile($helper));
        }

        $code[] = OpCode::SCOPE_RET;
        return $code;
    }
}
