<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Statement;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;

/**
 * Class ExpressionChain
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node
 */
class ExpressionChain extends AbstractNode
{
    /**
     * ExpressionChain constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(NodeInterface $left, NodeInterface $right)
    {
        parent::__construct('chain', $left, $right);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        return \array_merge(
            $this->left->compile($helper),
            $this->right->compile($helper)
        );
    }
}
