<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Literal;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;

/**
 * Class ListOfThings
 * @package Ghoti\Tools\Lispian\Assembly\Node\Literal
 */
class ListOfThings extends AbstractNode
{
    /**
     * ListOfThings constructor.
     *
     * @param NodeInterface $expressions
     */
    public function __construct(NodeInterface $expressions)
    {
        parent::__construct('lot', $expressions);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     * @throws SeriousBugException
     */
    public function compile(ScopeHelper $helper): array
    {
        throw new SeriousBugException(\sprintf('%s cannot be called', __METHOD__));
    }
}
