<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Literal;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class AsciiSequence
 *
 * Why not simply call it "String" you ask? Try for yourself.
 *
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Literal
 */
class AsciiSequence extends AbstractNode
{
    /**
     * AsciiSequence constructor.
     * @param string $string
     */
    public function __construct(string $string)
    {
        parent::__construct('string', $string);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        $key = $helper->getStaticData()->getReference($this->left);
        return [OpCode::LOAD, $key];
    }

    /**
     * @return string
     */
    public function stringify(): string
    {
        return (string) $this->left;
    }
}
