<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Functions;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Identifier;
use Ghoti\Tools\Lispian\Exception\VM\SymbolRedeclarationException;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\Symbol\CallableFunction;

/**
 * Class Definition
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Functions
 */
class Definition extends AbstractNode
{
    /**
     * Definition constructor.
     * @param NodeInterface $identifier
     * @param NodeInterface[] $parameters
     * @param NodeInterface $body
     */
    public function __construct(NodeInterface $identifier, NodeInterface $body, array $parameters = null)
    {
        parent::__construct('defun', $identifier, $parameters, $body);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     * @throws SymbolRedeclarationException
     */
    public function compile(ScopeHelper $helper): array
    {
        /** @var Identifier $functionName */
        $functionName = $this->left;
        $functionName = $functionName->left;
        /** @var AbstractNode $functionBody */
        $functionBody = $this->next;

        if (null !== $helper->getSymbolTable()->lookup($functionName)) {
            throw new SymbolRedeclarationException("Attempt to redeclare symbol '$functionName'");
        }

        $symbol = new CallableFunction($functionName);
        $parameters = $this->right ?? [];
        $symbol->setParameters($parameters);
        $symbol->setValue($functionBody->compile($helper));

        $helper->getSymbolTable()->store($symbol);

        return [];
    }
}
