<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Contracts;

use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;

/**
 * Class NodeInterface
 * @package Ghoti\Tools\Lispian\Assembly\Contracts
 */
interface NodeInterface
{
    /**
     * @param string $operator
     * @return NodeInterface
     */
    public function setOperator(string $operator): self;

    /**
     * @param NodeInterface|mixed $left
     * @return NodeInterface
     */
    public function setLeft($left): self;

    /**
     * @param NodeInterface|mixed $right
     * @return NodeInterface
     */
    public function setRight($right): self;

    /**
     * @param NodeInterface|mixed $next
     * @return NodeInterface
     */
    public function setNext($next): self;

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array;

    /**
     * @return string
     */
    public function __toString(): string;

    /**
     * @return string
     */
    public function stringify(): string;
}
