<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Compiler;

use Ghoti\Tools\Lispian\Assembly\Node\Pr0gram;

/**
 * Class StaticData
 * @package Ghoti\Tools\Lispian\VM\Compiler
 */
class StaticData
{
    /** @var array */
    protected $data;

    /**
     * StaticData constructor.
     */
    public function __construct()
    {
        $this->data = [];
    }

    /**
     * @param $data
     * @return int
     */
    public function getReference($data): int
    {
        $dataKey = $this->getDataKey(\serialize($data));

        if (!\array_key_exists($dataKey, $this->data)) {
            $this->data[$dataKey] = $data;
        }

        return \array_search($dataKey, \array_keys($this->data), true) + Pr0gram::PR0LOG;
    }

    /**
     * @return array
     */
    public function getStaticData(): array
    {
        return \array_values($this->data);
    }

    /**
     * @param string $serialized
     * @return string
     */
    protected function getDataKey(string $serialized): string
    {
        return \sha1($serialized);
    }
}
