<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Compiler;

/**
 * Class ScopeHelper
 *
 * @package Ghoti\Tools\Lispian\VM\Compiler
 */
class ScopeHelper
{
    /** @var StaticData */
    protected $staticData;
    /** @var SymbolTable */
    protected $symbolTable;

    /**
     * ScopeHelper constructor.
     * @param StaticData $data
     */
    public function __construct(StaticData $data, SymbolTable $table)
    {
        $this->staticData = $data;
        $this->symbolTable = $table;
    }

    /**
     * @return StaticData
     */
    public function getStaticData(): StaticData
    {
        return $this->staticData;
    }

    /**
     * @return SymbolTable
     */
    public function getSymbolTable(): SymbolTable
    {
        return $this->symbolTable;
    }
}
