<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Instruction;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Nop
 * @package Ghoti\Tools\Lispian\Assembly\Node\Instruction
 */
class Nop extends AbstractNode
{
    /**
     * Nop constructor.
     */
    public function __construct()
    {
        parent::__construct('NOP');
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        return [OpCode::NOP];
    }
}
