<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Addition
 * @package Ghoti\Tools\Lispian\Assembly\Node\Arithmetic
 */
class Addition extends AbstractNode
{
    /**
     * Addition constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(NodeInterface $left, NodeInterface $right)
    {
        parent::__construct('+', $left, $right);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        /** @var AbstractNode $summands */
        $summands = $this->right;

        $code = $this->left->compile($helper);

        /** @var AbstractNode $summand */
        foreach ($summands as $summand) {
            $code[] = OpCode::PUSH;
            \array_splice($code, \count($code), 0, $summand->compile($helper));
            $code[] = OpCode::ADD;
        }

        return $code;
    }
}
