<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Contracts;

use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;

/**
 * Trait CannotCompileTrait
 * @package Ghoti\Tools\Lispian\Assembly\Contracts
 */
trait CannotCompileTrait
{
    /**
     * @param ScopeHelper $helper
     * @return array
     * @throws SeriousBugException
     */
    public function compile(ScopeHelper $helper): array
    {
        throw new SeriousBugException(\sprintf('Cannot compile node "%s" by itself', \get_class($this)), 1541326332);
    }
}
