<?php
/**
 * @author    Oliver Schieche <spam+php-getopt@oliver-schieche.de>
 */

use Ghoti\Common\Console\Ansi as A;
use PHPUnit\Framework\TestCase;

/**
 * Test case for Ghoti\Common\Console\Ansi
 */
class AnsiTest extends TestCase
{
    public function testStaticCreation(): void
    {
        /** @noinspection UnnecessaryAssertionInspection */
        $this->assertInstanceOf(A::class, A::C());
    }

    /**
     * @throws \Ghoti\Common\Exception\InvalidArgumentException
     */
    public function testColorize(): void
    {
        $color = A::C('foobert @{red @{b was}} here. @{blue and then he @{u left}}.');
        $colorized = $color->colorize();

        $this->assertEquals("foobert \e[31m\e[1mwas\e[31\e[0m here. \e[34mand then he \e[4mleft\e[34\e[0m.", $colorized);
        $this->assertEquals($colorized, (string) $color);
    }

    public function testCTOR(): void
    {
        $color = new A('Format');
        $this->assertEquals('Format', (string) $color);
    }

    public function testInvoked(): void
    {
        $color = new A();
        /** @noinspection PhpParamsInspection */
        $this->assertEquals('Returned value', $color('Returned %s', 'value'));
    }

    public function testTostringException(): void
    {
        $color = new A('@{invalid Text}');
        $value = (string) $color;
        $this->assertEquals("Invalid formatting code 'invalid'", $value);
    }

    /**
     * @throws \Ghoti\Common\Exception\InvalidArgumentException
     */
    public function testEmptyTag(): void
    {
        $value = A::C('@{green}')->colorize();
        $this->assertEquals('', $value);
    }

    /**
     * @throws \Ghoti\Common\Exception\InvalidArgumentException
     * @expectedException \Ghoti\Common\Exception\InvalidArgumentException
     * @expectedExceptionMessage Unterminated tags in '@{green Hello @{u world.}'
     */
    public function testUnterminatedException(): void
    {
        A::C('@{green Hello @{u world.}')->colorize();
    }

    /**
     * @throws \Ghoti\Common\Exception\InvalidArgumentException
     */
    public function testUncolorized(): void
    {
        $this->assertEquals('Gork!', A::C('@{red Gork}!')->setEnableColors(false)->colorize());
    }
}
