<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
use Ghoti\Tools\Common\Utils\StringWrapper;
use PHPUnit\Framework\TestCase;

class StringWrapperTest extends TestCase
{
    public function test__construct()
    {
        $this->assertInstanceOf(StringWrapper::class, new StringWrapper(20));
    }

    public function testGetFirstIndention()
    {
        $firstIndention = 5;
        $wrapper = new StringWrapper(10, $firstIndention);
        $this->assertEquals($firstIndention, $wrapper->getFirstIndention());
    }

    public function testSetFirstIndention()
    {
        $wrapper = new StringWrapper(10);

        $firstIndention = 5;
        $wrapper->setFirstIndention($firstIndention);
        $this->assertEquals($firstIndention, $wrapper->getFirstIndention());
    }

    public function testGetLeftIndention()
    {
        $leftIndention = 5;
        $wrapper = new StringWrapper(10, 0, $leftIndention);
        $this->assertEquals($leftIndention, $wrapper->getLeftIndention());
    }

    public function testSetLeftIndention()
    {
        $wrapper = new StringWrapper(10);

        $leftIndention = 5;
        $wrapper->setLeftIndention($leftIndention);
        $this->assertEquals($leftIndention, $wrapper->getLeftIndention());
    }

    public function testGetMargin()
    {
        $wrapper = new StringWrapper($margin = 5);
        $this->assertEquals($margin, $wrapper->getMargin());
    }

    public function testSetMargin()
    {
        $wrapper = new StringWrapper(10);

        $newMargin = 5;
        $wrapper->setMargin($newMargin);
        $this->assertEquals($newMargin, $wrapper->getMargin());
    }

    public function testWrap()
    {
        $wrapper = new StringWrapper(50, 4, 8);
        $text = <<<EOT
At the preemptory request of a large number of the citizens of these United States, I, Joshua Norton, formerly of Algoa Bay, Cape of Good Hope, and for the past nine years and ten months of San Francisco, California, declare and proclaim myself Emperor of these United States, and in virtue of the authority in me vested, do hereby order and direct the representatives of the different states of the Union to assemble in the music hall of this city on the 1st day of February next, then and there to make such alterations in the existing laws of the Union as may ameliorate the evils under which the country is laboring, and thereby cause confidence to exist, both at home and abroad, in our stability and integrity. signed, Norton I, Emperor of the United States.
EOT;

        $wrapped = $wrapper($text);
        $expect = [
            0 => 'At the preemptory request of a large number',
            1 => '        of the citizens of these United States,',
            2 => '        I, Joshua Norton, formerly of Algoa Bay,',
            3 => '        Cape of Good Hope, and for the past nine',
            4 => '        years and ten months of San Francisco,',
            5 => '        California, declare and proclaim myself',
            6 => '        Emperor of these United States, and in',
            7 => '        virtue of the authority in me vested, do',
            8 => '        hereby order and direct the',
            9 => '        representatives of the different states',
            10 => '        of the Union to assemble in the music',
            11 => '        hall of this city on the 1st day of',
            12 => '        February next, then and there to make',
            13 => '        such alterations in the existing laws of',
            14 => '        the Union as may ameliorate the evils',
            15 => '        under which the country is laboring, and',
            16 => '        thereby cause confidence to exist, both',
            17 => '        at home and abroad, in our stability and',
            18 => '        integrity. signed, Norton I, Emperor of',
            19 => '        the United States.',
        ];

        $this->assertEquals($expect, $wrapped);
    }

    public function testWrapNewlineRemoval()
    {
        $wrapper = new StringWrapper(50, 4, 8);
        $text = <<<EOT
At the preemptory request of a large number of the citizens of these United 
States, I, Joshua Norton, formerly of Algoa Bay, Cape of Good Hope, and for the 
past nine years and ten months of San Francisco, California, declare and 
proclaim myself Emperor of these United States, and in virtue of the authority 
in me vested, do hereby order and direct the representatives of the different 
states of the Union to assemble in the music hall of this city on the 1st day of 
February next, then and there to make such alterations in the existing laws of 
the Union as may ameliorate the evils under which the country is laboring, and 
thereby cause confidence to exist, both at home and abroad, in our stability and 
integrity. signed, Norton I, Emperor of the United States.
EOT;

        $wrapped = $wrapper($text);
        $expect = [
            0 => 'At the preemptory request of a large number',
            1 => '        of the citizens of these United States,',
            2 => '        I, Joshua Norton, formerly of Algoa Bay,',
            3 => '        Cape of Good Hope, and for the past nine',
            4 => '        years and ten months of San Francisco,',
            5 => '        California, declare and proclaim myself',
            6 => '        Emperor of these United States, and in',
            7 => '        virtue of the authority in me vested, do',
            8 => '        hereby order and direct the',
            9 => '        representatives of the different states',
            10 => '        of the Union to assemble in the music',
            11 => '        hall of this city on the 1st day of',
            12 => '        February next, then and there to make',
            13 => '        such alterations in the existing laws of',
            14 => '        the Union as may ameliorate the evils',
            15 => '        under which the country is laboring, and',
            16 => '        thereby cause confidence to exist, both',
            17 => '        at home and abroad, in our stability and',
            18 => '        integrity. signed, Norton I, Emperor of',
            19 => '        the United States.',
        ];

        $this->assertEquals($expect, $wrapped);
    }

    public function testVeryLongLineWrap()
    {
        $wrapper = new StringWrapper(15);
        $wrapped = $wrapper('ThisIsAVeryLongLineThatSomehowContainsNoSingleWhitespace.');
        $expect = ['ThisIsAVeryLong', 'LineThatSomehow', 'ContainsNoSingl', 'eWhitespace.'];

        $this->assertEquals($expect, $wrapped);
    }
}
