<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */


use Ghoti\Tools\Common\Console\Info;
use PHPUnit\Framework\TestCase;

class InfoTest extends TestCase
{
    public function testIsConsoleInteractive()
    {
        if (PHP_VERSION_ID < 70200) {
            if (0 === \stripos(PHP_OS, 'WIN')) {
                return $this->markTestSkipped('Cannot test in Windows and PHP < 7.2 ');
            }

            if (!extension_loaded('posix')) {
                return $this->markTestSkipped('Cannot test without posix extension');
            }
        }

        /** @var \PHPUnit\Framework\MockObject\MockObject $mock */
        $mock = $this->getMockBuilder(Info::class)
            ->setMethods(['getTestFileHandle'])->getMock();

        $mock->expects($this->once())
            ->method('getTestFileHandle')
            ->willReturn(\tmpfile());

        /** @var Info $info */
        $info = $mock;
        $this->assertFalse($info->isConsoleInteractive());
    }
}
