<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
use Ghoti\Tools\Common\Configuration\ConfigurationStore;
use PHPUnit\Framework\TestCase;

/**
 * Class ConfigurationStoreTest
 */
class ConfigurationStoreTest extends TestCase
{
    public function testGetConfiguration()
    {
        /** @noinspection UnnecessaryAssertionInspection */
        $this->assertInstanceOf(ConfigurationStore::class, ConfigurationStore::getConfiguration());
    }

    public function testMerge()
    {
        $config = ConfigurationStore::getConfiguration();
        $config->merge(new TestConfigSource());

        $this->assertEquals('app.xml', $config['filename']);
    }

    public function testCodeCoverage()
    {
        $config = ConfigurationStore::getConfiguration();

        $this->assertFalse($config->offsetExists('Gork'));
        $config['Gork'] = 'Znarf';
        $this->assertEquals('Znarf', $config['Gork']);
        unset($config['Gork']);
        $this->assertFalse($config->offsetExists('Gork'));
    }
}

class TestConfigSource implements \Ghoti\Tools\Common\Configuration\ConfigurationInterface
{
    /**
     * @return array
     */
    public function getConfiguration(): array
    {
        return [
            'filename' => 'app.xml'
        ];
    }
}