<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
use Ghoti\Tools\Common\Configuration\ConfigurationStore;
use Ghoti\Tools\Common\Configuration\Source\File;
use PHPUnit\Framework\TestCase;

class ConfigurationFileTest extends TestCase
{
    /**
     * @throws Exception
     */
    public function testGetConfiguration()
    {
        $configFile = new File(FixtureLoader::getFilePath('config.php'));
        $configuration = ConfigurationStore::getConfiguration();
        $configuration->merge($configFile);

        $this->assertEquals([
            'host' => 'localhost',
            'name' => 'admin',
            'user' => 'root',
            'pass' => 's3kr3t',
        ], $configuration['database']);
    }

    /**
     * @expectedException Ghoti\Tools\Common\Exception\RuntimeException
     * @expectedExceptionMessageRegExp /invalid_config[.]php" did not yield an array for use as configuration data/
     */
    public function testInvalidSource()
    {
        $configFile = new File(FixtureLoader::getFilePath('invalid_config.php'));
        ConfigurationStore::getConfiguration()->merge($configFile);
    }

}
