<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
use Ghoti\Tools\Common\Utils\ArrayHelper;
use PHPUnit\Framework\TestCase;

/**
 * Class ArrayHelperTest
 */
class ArrayHelperTest extends TestCase
{
    public function testMerge()
    {
        $left = [
            'foo' => 'bar',
            'list' => [
                'item0' => 'value0',
                'item1' => 'value1',
                'item2' => 'value2'
            ]
        ];

        $right = [
            'complement' => 'list',
            'list' => [
                'item3' => 'value3'
            ]
        ];

        $result = ArrayHelper::merge($left, $right);
        $expected = [
            'foo' => 'bar',
            'complement' => 'list',
            'list' => [
                'item0' => 'value0',
                'item1' => 'value1',
                'item2' => 'value2',
                'item3' => 'value3'
            ]
        ];
        $this->assertEquals($expected, $result);

        $result = ArrayHelper::merge([0, 1], [2, 3]);
        $this->assertEquals([0,1,2,3], $result);
    }

    public function testFlatten()
    {
        $result = ArrayHelper::flatten([1, 2, ['3', 4, 5], [6, '7'], '8', 9, 'ten' => 10]);
        $expected = [1, 2, '3', 4, 5, 6, '7', '8', 9, 10];

        $this->assertEquals($expected, $result);
    }

    public function testMap()
    {
        $input = [1, 2, 3, 4, 5, 6, 7, 8];
        $expected = [2, 4, 6, 8, 10, 12, 14, 16];
        $result = ArrayHelper::map($input, function($n) {
            return 2 * $n;
        });

        $this->assertEquals($expected, $result);
    }

    public function testSplit()
    {
        $this->assertEquals(['Hello', 'world.'], ArrayHelper::split(' ', 'Hello world.'));
        $this->assertEquals(['Hello', 'desolate world.'], ArrayHelper::split(' ', 'Hello desolate world.', 2));
    }
}
