<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */

/** @noinspection AutoloadingIssuesInspection */
class FixtureLoader
{
    /**
     * @param $filename
     * @return string
     * @throws RuntimeException
     */
    public static function getFilePath($filename): string
    {
        $path = realpath(implode(DIRECTORY_SEPARATOR, [
            __DIR__, 'fixtures', $filename
        ]));

        if (false === $path) {
            throw new \RuntimeException("Fixture not found: $filename");
        }

        return $path;
    }
}

require dirname(__DIR__) . '/vendor/autoload.php';
