<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Traits;

/**
 * Trait SingletonTrait
 * @package Ghoti\Tools\Common\Traits
 */
trait SingletonTrait
{
    /** @var SingletonTrait */
    static protected $instance;

    public static function getInstance(): self
    {
        if (null === static::$instance) {
            static::$instance = static::createInstance();
        }

        return static::$instance;
    }

    /**
     * @return SingletonTrait
     */
    protected static function createInstance(): self
    {
        return new static();
    }
}
