<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Exception;

use Throwable;
use function json_last_error;
use function json_last_error_msg;

/**
 * Class InvalidJsonException
 * @package Ghoti\Tools\Common\Exception
 */
class InvalidJsonException extends InvalidArgumentException
{
    /** @var int */
    protected $jsonErrorCode;
    /** @var string */
    protected $jsonErrorString;
    /** @var string */
    protected $jsonPayload;

    /**
     * InvalidJsonException constructor.
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct(string $message = '', int $code = 0, Throwable $previous = null)
    {
        $this->jsonErrorCode = json_last_error();
        $this->jsonErrorString = json_last_error_msg();
        parent::__construct($this->augmentError($message), $code, $previous);
    }

    /**
     * @return string
     */
    public function getJsonPayload(): string
    {
        return $this->jsonPayload;
    }

    /**
     * @param string $jsonPayload
     * @return InvalidJsonException
     */
    public function setJsonPayload(string $jsonPayload): InvalidJsonException
    {
        $this->jsonPayload = $jsonPayload;
        return $this;
    }

    /**
     * @param string $message
     * @return string
     */
    protected function augmentError(string $message): string
    {
        return sprintf('JSON error #%d: %s: %s', $this->jsonErrorCode, $this->jsonErrorString, $message);
    }
}
