<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Exception;

use Ghoti\Tools\Common\System\Process;
use Throwable;

/**
 * Class ExecutionException
 * @package Ghoti\Tools\Common\Exception
 */
class ExecutionException extends \RuntimeException implements ExceptionInterface
{
    /** @var Process */
    protected $process;

    /**
     * ExecutionException constructor.
     *
     * @param Process        $process
     * @param string         $message
     * @param int            $code
     * @param Throwable|null $previous
     */
    public function __construct(Process $process, $message = '', $code = 0, Throwable $previous = null)
    {
        $this->setProcess($process);
        parent::__construct($message, $code, $previous);
    }

    /**
     * @return Process
     */
    public function getProcess(): Process
    {
        return $this->process;
    }

    /**
     * @param Process $process
     *
     * @return ExecutionException
     */
    public function setProcess(Process $process): ExecutionException
    {
        $this->process = $process;
        return $this;
    }
}
