<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Data;

use Ghoti\Tools\Common\Exception\InvalidJsonException;
use JsonException;
use function json_decode;
use const JSON_THROW_ON_ERROR;

/**
 * Class Json
 * @package Ghoti\Tools\Common\Data
 */
class Json
{
    /** @var int */
    public const DECODE_DEFAULT = 0;
    /** @var int */
    public const DECODE_ARRAY = 1;

    /**
     * @param string $json
     * @param int $flags
     * @return mixed
     * @throws InvalidJsonException
     */
    public static function decode(string $json, int $flags = self::DECODE_DEFAULT)
    {
        $asArray = (static::DECODE_ARRAY === ($flags & static::DECODE_ARRAY));

        try {
            return json_decode($json, $asArray, 512, JSON_THROW_ON_ERROR);
        } catch (JsonException $exception) {
            throw (new InvalidJsonException('Failed to decode data', $exception->getCode(), $exception))->setJsonPayload($json);
        }
    }
}
