<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Console;

use Ghoti\Tools\Common\Traits\SingletonTrait;
use function extension_loaded;
use function posix_isatty;
use function stream_isatty;
use const STDOUT;

/**
 * Class Info
 * @package Ghoti\Tools\Common\Console
 */
class Info
{
    use SingletonTrait;

    /**
     * @return bool
     */
    public function isConsoleInteractive(): bool
    {
        return $this->testHandleInteractive($this->getTestFileHandle());
    }

    /**
     * @return resource
     */
    protected function getTestFileHandle()
    {
        return STDOUT;
    }

    /**
     * @param resource $fd
     * @return bool
     */
    protected function testHandleInteractive($fd): bool
    {
        if (PHP_VERSION_ID >= 70200) {
            return stream_isatty($fd);
        }

        if (extension_loaded('posix')) {
            return posix_isatty($fd);
        }

        return true;
    }
}
