<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */

use Ghoti\Tools\Common\Data\Json;
use Ghoti\Tools\Common\Exception\InvalidJsonException;
use PHPUnit\Framework\TestCase;

class JsonTest extends TestCase
{
    /**
     * @throws InvalidJsonException
     */
    public function testDecodeSuccess()
    {
        $data = Json::decode('{}');
        $this->assertEquals((object) [], $data);
    }

    /**
     * @throws InvalidJsonException
     */
    public function testDecodeArray()
    {
        $data = Json::decode('{}', Json::DECODE_ARRAY);
        $this->assertEquals([], $data);
    }

    /**
     * @throws InvalidJsonException
     * @expectedException Ghoti\Tools\Common\Exception\InvalidJsonException
     * @expectedExceptionCode 4
     */
    public function testFailed()
    {
        Json::decode('gork');
    }

    public function testPayloadException()
    {
        try {
            Json::decode($payload = 'Blurbargh');
        } catch(\Exception $exception) {
            $this->assertInstanceOf(InvalidJsonException::class, $exception);
            /** @var InvalidJsonException $exception */
            $this->assertEquals($payload, $exception->getJsonPayload());
        }
    }
}
