<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Data;

use Ghoti\Tools\Common\Exception\InvalidJsonException;

/**
 * Class Json
 * @package Ghoti\Tools\Common\Data
 */
class Json
{
    /** @var int */
    const DECODE_DEFAULT = 0;
    /** @var int */
    const DECODE_ARRAY = 1;

    /**
     * @param string $json
     * @param int $flags
     * @return mixed
     * @throws InvalidJsonException
     */
    public static function decode(string $json, int $flags = self::DECODE_DEFAULT)
    {
        $asArray = (static::DECODE_ARRAY === ($flags & static::DECODE_ARRAY));

        if (null === ($data = \json_decode($json, $asArray))) {
            throw (new InvalidJsonException('Failed to decode data', \json_last_error()))->setJsonPayload($json);
        }

        return $data;
    }
}