<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */

use Ghoti\Tools\Common\Os\Filename;
use PHPUnit\Framework\TestCase;

/**
 * Class FilenameTest
 */
class FilenameTest extends TestCase
{
    /**
     * @expectedException Ghoti\Tools\Common\Exception\FileNotFoundException
     */
    public function testAbsolutizeNoFile()
    {
        $file = implode(DIRECTORY_SEPARATOR, [__DIR__, 'not-there']);

        // it really shouldn't be here.
        if (file_exists($file)) {
            unlink($file);
        }

        Filename::absolutize($file);
    }

    public function testAbsolutizePath()
    {
        $file = implode(DIRECTORY_SEPARATOR, [__DIR__, '..', 'unit', '.', 'still-not-there']);

        try {
            touch($file);
            $absolute = Filename::absolutize($file);
            $expected = implode(DIRECTORY_SEPARATOR, [__DIR__, 'still-not-there']);

            $this->assertEquals($expected, $absolute);
        } finally {
            unlink($file);
        }
    }
}
