<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
use Ghoti\Tools\Common\Utils\ArrayHelper;
use PHPUnit\Framework\TestCase;

/**
 * Class ArrayHelperTest
 */
class ArrayHelperTest extends TestCase
{
    public function testMerge()
    {
        $left = [
            'foo' => 'bar',
            'list' => [
                'item0' => 'value0',
                'item1' => 'value1',
                'item2' => 'value2'
            ]
        ];

        $right = [
            'complement' => 'list',
            'list' => [
                'item3' => 'value3'
            ]
        ];

        $result = ArrayHelper::merge($left, $right);
        $expected = [
            'foo' => 'bar',
            'complement' => 'list',
            'list' => [
                'item0' => 'value0',
                'item1' => 'value1',
                'item2' => 'value2',
                'item3' => 'value3'
            ]
        ];
        $this->assertEquals($expected, $result);
    }
}
