<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */

use Ghoti\Tools\Common\Console\Ansi as A;
use PHPUnit\Framework\TestCase;

class AnsiTest extends TestCase
{
    public function testStaticCreation()
    {
        /** @noinspection UnnecessaryAssertionInspection */
        $this->assertInstanceOf(A::class, A::C());
    }

    /**
     * @throws \Ghoti\Tools\Common\Exception\InvalidArgumentException
     */
    public function testColorize()
    {
        $color = A::C('foobert @{red @{b was}} here. @{blue and then he @{u left}}.');
        $colorized = $color->colorize();

        $this->assertEquals("foobert \e[31m\e[1mwas\e[31\e[0m here. \e[34mand then he \e[4mleft\e[34\e[0m.", $colorized);
        $this->assertEquals($colorized, (string) $color);
    }

    public function testCTOR()
    {
        $color = new A('Format');
        $this->assertEquals('Format', (string) $color);
    }

    public function testInvoked()
    {
        $color = new A();
        $this->assertEquals('Returned value', $color('Returned %s', 'value'));
    }

    public function testTostringException()
    {
        $color = new A('@{invalid Text}');
        $value = (string) $color;
        $this->assertEquals("Invalid formatting code 'invalid'", $value);
    }

    /**
     * @throws \Ghoti\Tools\Common\Exception\InvalidArgumentException
     */
    public function testEmptyTag()
    {
        $value = A::C('@{green}')->colorize();
        $this->assertEquals('', $value);
    }

    /**
     * @throws \Ghoti\Tools\Common\Exception\InvalidArgumentException
     * @expectedException \Ghoti\Tools\Common\Exception\InvalidArgumentException
     * @expectedExceptionMessage Unterminated tags in '@{green Hello @{u world.}'
     */
    public function testUnterminatedException()
    {
        A::C('@{green Hello @{u world.}')->colorize();
    }

    /**
     * @throws \Ghoti\Tools\Common\Exception\InvalidArgumentException
     */
    public function testUncolorized()
    {
        A::enableColors(false);
        $this->assertEquals('Gork!', A::C('@{red Gork}!')->colorize());
    }
}
