<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Utils;

/**
 * Class ArrayHelper
 * @package Ghoti\Tools\Common\Utils
 */
class ArrayHelper
{
    /**
     * @param array $source
     * @param array[] ...$input
     * @return array
     */
    public static function merge(array $source, array ...$input): array
    {
        foreach ($input as $item) {
            $source = static::mergeArrays($source, $item);
        }

        return $source;
    }

    /**
     * @param array $a
     * @param array $b
     * @return array
     */
    private static function mergeArrays(array $a, array $b): array
    {
        foreach ($b as $k => $v) {
            if (\is_array($v) && isset($a[$k]) && \is_array($a[$k])) {
                $a[$k] = static::mergeArrays($a[$k], $v);
            } else {
                $a[$k] = $v;
            }
        }

        return $a;
    }
}