<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Os;
use Ghoti\Tools\Common\Exception\FileNotFoundException;

/**
 * Class Filename
 * @package Ghoti\Tools\Common\Os
 */
class Filename
{
    /**
     * @param string $filename
     * @return string
     * @throws \Ghoti\Tools\Common\Exception\FileNotFoundException
     */
    public static function absolutize(string $filename): string
    {
        if (false === ($path = \realpath($filename))) {
            throw new FileNotFoundException($filename);
        }

        return $path;
    }
}